<?php
/*--------------------------------------------------------------
   Collector.php 2021-06-17
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Data;

use Gambio\Admin\Modules\Statistics\App\Overview\Factory;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\WidgetDefinitions;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Entities\WidgetDefinition;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Type;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Visualization;
use InvalidArgumentException;
use Webmozart\Assert\Assert;

class Collector
{
    /**
     * @var WidgetDefinition[]
     */
    private $widgetDefinitions;
    
    /**
     * @var Factory
     */
    private $factory;
    
    
    /**
     * Constructor.
     */
    public function __construct(Factory $factory)
    {
        $this->factory           = $factory;
        $this->widgetDefinitions = [];
    }
    
    
    /**
     * Return widget definitions.
     */
    public function getWidgetDefinitions(): WidgetDefinitions
    {
        return $this->factory->createWidgetDefinitions(...array_values($this->widgetDefinitions));
    }
    
    
    /**
     * Return widget definition by type.
     */
    public function getWidgetDefinitionByType(Type $type): WidgetDefinition
    {
        Assert::keyExists($this->widgetDefinitions, $type->value());
        
        return $this->widgetDefinitions[$type->value()];
    }
    
    
    /**
     * Register widget definition.
     */
    public function registerWidgetDefinition(WidgetDefinition $widgetDefinition): void
    {
        $type = $widgetDefinition->type()->value();
        
        if (!array_key_exists($type, $this->widgetDefinitions)) {
            $this->widgetDefinitions[$type] = $widgetDefinition;
        }
    }
}